unit MAIN;

//        . 
//      
//      
//    .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, ExtCtrls,
  MainDef, GridEditor01, CommonFileTools;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    EditFilterName: TEdit;
    StringGrid1: TStringGrid;
    Memo1: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    STextRecIndx: TStaticText;
    Label6: TLabel;
    PanelCtrlDB: TPanel;
    ButtOpenDB: TButton;
    ButtCloseDB: TButton;
    ButtSelectDB: TButton;
    STextOpenID: TStaticText;
    PanelRecSelector: TPanel;
    LBoxRecName: TListBox;
    CBoxRecStat: TComboBox;
    Button5: TButton;
    PanelCtrlRec: TPanel;
    ButtAddRec: TButton;
    ButtUpDateRec: TButton;
    ButtDelRec: TButton;
    ButtRestoreRec: TButton;
    Bevel1: TBevel;
    Label7: TLabel;
    EditScale: TEdit;
    ButtCalcScale: TButton;
    ButtClearFilter: TButton;
    Bevel2: TBevel;
    Label5: TLabel;
    Bevel3: TBevel;
    CBoxFilterType: TComboBox;
    Label8: TLabel;
    OpenDialog1: TOpenDialog;
    Label9: TLabel;
    procedure ButtUpDateRecClick(Sender: TObject);
    procedure ButtAddRecClick(Sender: TObject);
    procedure ButtOpenDBClick(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure LBoxRecNameClick(Sender: TObject);
    procedure StringGrid1SetEditText(Sender: TObject; ACol, ARow: Integer;
      const Value: String);
    procedure ButtCloseDBClick(Sender: TObject);
    procedure ButtDelRecClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ButtRestoreRecClick(Sender: TObject);
    procedure CBoxRecStatClick(Sender: TObject);
    procedure EditScaleChange(Sender: TObject);
    procedure ButtClearFilterClick(Sender: TObject);
    procedure ButtCalcScaleClick(Sender: TObject);
    procedure ButtSelectDBClick(Sender: TObject);
  private
    { Private declarations }
    //      
    procedure SaveBufRecord (var RqBufRec : TFilterBuf);
  public
    { Public declarations }
    procedure ShowBufRecord (RqBufRec : TFilterBuf);
  end;

var
  Form1  : TForm1;

var MicroBase : TMicroBase;

implementation
{$R *.dfm}

//========================================================================
//    /  
//========================================================================
//  
procedure TForm1.FormCreate(Sender: TObject);
begin
 FilterFileName := '.\Filters\FilterBase.fdb';
 Self.Caption := '  ' + FilterFileName;
 ptFRBuf := Addr(FRBuf);
 MicroBase := TMicroBase.Create(SizeOf(TFilterBuf));
end;
//  
procedure TForm1.FormDestroy(Sender: TObject);
begin
 MicroBase.Free();
 MicroBase := nil;
end;
//========================================================================
//     
//========================================================================
//   
function CalcScale(var RqBufRec : TFilterBuf) : integer;
var wRow, wCol : byte;
    Sum : integer;
begin
   Sum := 0;
   for wRow := Low(RqBufRec.Filter) to High(RqBufRec.Filter)
   do for wCol := Low(RqBufRec.Filter[wRow]) to High(RqBufRec.Filter[wRow])
      do Sum := Sum + RqBufRec.Filter[wRow, wCol];
   Result := Sum;
end;
//------------------------------------------------------------------------
//   
procedure ClearFilter(var RqBufRec : TFilterBuf);
var wRow, wCol : byte;
begin
   for wRow := Low(RqBufRec.Filter) to High(RqBufRec.Filter)
   do for wCol := Low(RqBufRec.Filter[wRow]) to High(RqBufRec.Filter[wRow])
      do RqBufRec.Filter[wRow, wCol] := 0;
end;
//------------------------------------------------------------------------
//    
procedure SetRandomFilter(RqFilter : integer; var RqBufRec : TFilterBuf);
const Impact : array[0..4,0..4] of integer =
((2, 2, 2, 2, 2),
 (2, 4, 4, 4, 2),
 (2, 4, 0, 4, 2),
 (2, 4, 4, 4, 2),
 (2, 2, 2, 2, 2));
var wRow,  wCol : byte;
    Coeff, Sum  : integer;
begin
   Randomize;
   Sum := 0;
   for wRow := Low(RqBufRec.Filter) to High(RqBufRec.Filter) do
   begin
     for wCol := Low(RqBufRec.Filter[wRow]) to High(RqBufRec.Filter[wRow])
     do begin
        if Impact[wRow, wCol] > 0
        then Coeff := Random(Impact[wRow, wCol]) else Coeff := 0;
        case RqFilter of
         0 :  RqBufRec.Filter[wRow, wCol] :=   Coeff;
         1 :  RqBufRec.Filter[wRow, wCol] := - Coeff;
         else RqBufRec.Filter[wRow, wCol] := 0;
        end;
        Sum := Sum + Coeff;
   end; end;
   case RqFilter of
   0 : begin
         RqBufRec.Filter[2, 2] := Sum div 2;
         RqBufRec.Scale :=  Sum + Sum div 2;
       end;
   1 : begin
         RqBufRec.Filter[2, 2] := Abs(Sum) + 1;
         RqBufRec.Scale := 1;
       end;
   end;
end;
//------------------------------------------------------------------------
//       
procedure MakeNewFilterRecord(var RqBufRec : TFilterBuf);
var wInd : byte;
begin
   RqBufRec.Name := ' ';
   ClearFilter(RqBufRec);
   RqBufRec.Scale := 0;
   for wInd := Low(RqBufRec.Comment) to High(RqBufRec.Comment)
   do RqBufRec.Comment[wInd]:='';
end;
//------------------------------------------------------------------------
//       
procedure TForm1.SaveBufRecord (var RqBufRec : TFilterBuf);
var IndCol : byte;
begin
   RqBufRec.Name := EditFilterName.Text;
   for IndCol:= Low(RqBufRec.Comment) to High(RqBufRec.Comment)
   do RqBufRec.Comment[IndCol] := Memo1.Lines[IndCol];
   //       
end;
//------------------------------------------------------------------------
//    
procedure TForm1.ShowBufRecord (RqBufRec : TFilterBuf);
var IndRow, IndCol : byte;  FVal : integer;
begin
   EditFilterName.Text := RqBufRec.Name;
   EditScale.Text := IntToStr(RqBufRec.Scale);
   for IndRow:= 0 to 4 do
   begin
     for IndCol:= 0 to 4 do
     begin
       FVal := RqBufRec.Filter[IndCol, IndRow];
       if FVal <> 0
       then StringGrid1.Cells[IndCol, IndRow]:= IntToStr(FVal)
       else StringGrid1.Cells[IndCol, IndRow]:= '';
     end;
   end;
   Memo1.Clear;
   for IndCol:= Low(RqBufRec.Comment) to High(RqBufRec.Comment)
   do Memo1.Lines.Add(RqBufRec.Comment[IndCol]);
end;
//------------------------------------------------------------------------
//   
procedure TForm1.ButtClearFilterClick(Sender: TObject);
begin
   ClearFilter(FRBuf);
   ShowBufRecord (FRBuf);
end;
//   
procedure TForm1.Button5Click(Sender: TObject);
begin
  SetRandomFilter(CBoxFilterType.ItemIndex, FRBuf);
  ShowBufRecord (FRBuf);
end;

//   
procedure TForm1.ButtCalcScaleClick(Sender: TObject);
begin
  FRBuf.Scale :=  CalcScale(FRBuf);
  ShowBufRecord (FRBuf);
end;

//------------------------------------------------------------------------
//    
//------------------------------------------------------------------------
//        
function ProStrToFloat (RqStr : string; var RqFloat : double) : boolean;
begin
  Result  := False;
  try
    if RqStr <> ''
    then RqFloat := StrToFloat(RqStr)
    else RqFloat := 0;
    Result  := True;
  except MessageDlg('    ', mtError, [mbOk], 0);
  end;
end;
//------------------------------------------------------------------------
//        
function ProStrToInt (RqStr : string; var RqInt : integer) : boolean;
begin
  Result  := False;
  try
    if RqStr <> ''
    then RqInt := StrToInt(RqStr)
    else RqInt := 0;
    Result := True;
  except MessageDlg('    ', mtError, [mbOk], 0);
  end;
end;
//------------------------------------------------------------------------
//    
procedure TForm1.StringGrid1SetEditText(Sender: TObject; ACol,
  ARow: Integer; const Value: String);
begin
    //    OnSetEditText   TStringGrid
    EditInGrid2DIntegerArray(Sender, ACol, ARow, Value, FRBuf.Filter);
end;
//------------------------------------------------------------------------
//   
procedure TForm1.EditScaleChange(Sender: TObject);
var wSave : integer;
begin
  wSave := FRBuf.Scale;
  if not ProStrToInt(EditScale.Text, FRBuf.Scale)
  then FRBuf.Scale := wSave;
end;

//========================================================================
//    ( )
//========================================================================
//       
function GetRecIndexFromBox (RqBox : TListBox) : integer;
begin
  Result := -1;
  //     
  if RqBox.ItemIndex >= 0
  then begin
     //        
     Result := RqBox.ItemIndex;
     Result := Integer(RqBox.Items.Objects[Result]);
  end;
end;
//------------------------------------------------------------------------
//         
procedure LoadBaseSelector(RqBase : TMicroBase;
                           RqStat : byte;
                           RqBox  : TListBox);
var PDat    : pointer;  //    
    RqIndx  : integer;  //   
begin
  RqBox.Clear;
  if Assigned(RqBase)
  then begin
     //     
     RqIndx := 0;
     PDat := RqBase.ReadRecFromFile(RqIndx);
     //    
     while PDat <> nil
     do begin
        //       
        if RqBase.RecStat = RqStat
        then begin
           with  TFilterBuf(PDat^)
           do RqBox.Items.AddObject(Name, Pointer(MicroBase.RecIndx));
        end;
        //   
        RqIndx := RqIndx + 1;
        PDat := RqBase.ReadRecFromFile(RqIndx);
     end;
  end;
end;
//------------------------------------------------------------------------
//    
procedure TForm1.CBoxRecStatClick(Sender: TObject);
begin
  if Assigned(MicroBase)
  then begin
    if MicroBase.OpenOk
    then begin
       case CBoxRecStat.ItemIndex of
       0 : begin  //    
            LoadBaseSelector(MicroBase, rsDataRec, LBoxRecName);
            //    ( )
            ButtAddRec.Enabled := True;
            ButtDelRec.Enabled := True;
            ButtRestoreRec.Enabled := False;
           end;
       1 : begin  //    
            LoadBaseSelector(MicroBase, rsDeletedRec, LBoxRecName);
            //    ( )
            ButtAddRec.Enabled := False;
            ButtDelRec.Enabled := False;
            ButtRestoreRec.Enabled := True;
           end;
       end;
    end;
  end;
end;

//========================================================================
//      
//========================================================================
//      
procedure TForm1.ButtOpenDBClick(Sender: TObject);
begin
  if Assigned(MicroBase)
  then begin
     if MicroBase.OpenMicroBase(FilterFileName)
     then begin
       //    
       CBoxRecStat.ItemIndex := 0;
       LoadBaseSelector(MicroBase, rsDataRec, LBoxRecName);
       //    ( )
       ButtDelRec.Enabled := True;
       ButtRestoreRec.Enabled := False;
       //    ( )
       STextOpenID.Color := clLime;
       PanelCtrlRec.Visible := True;   //     
       ButtOpenDB.Enabled := False;    //    
       ButtCloseDB.Enabled := True;    //   
       ButtSelectDB.Enabled := False;  //   
     end;
  end;
end;
//------------------------------------------------------------------------
//      
procedure TForm1.ButtCloseDBClick(Sender: TObject);
begin
   if Assigned(MicroBase) then MicroBase.CloseMicroBase;
   LBoxRecName.Clear;
   //    ( )
   STextOpenID.Color := clBtnFace;
   PanelCtrlRec.Visible := False;  //     
   ButtOpenDB.Enabled := True;     //   
   ButtCloseDB.Enabled := False;   //    
   ButtSelectDB.Enabled := True;   //   
end;
//------------------------------------------------------------------------
//      
procedure TForm1.ButtSelectDBClick(Sender: TObject);
begin
  FilterFileName := '';
  OpenDialog1.Filter := 'Microbase files (*.FDb)|*.FDB';
  if OpenDialog1.Execute
  then begin
    FilterFileName := OpenDialog1.FileName;
    Self.Caption :=  '  ' + FilterFileName;
  end;
end;


//========================================================================
//      
//========================================================================
//        
function WriteFilter (RqBase  : TMicroBase;  //    
                      RqIndx  : integer;     //    
                      RqPBuf  : pointer;     //    
                      RqStat  : byte ): boolean;
begin
  Result := False;
  if Assigned(RqBase) and (RqIndx >= 0) and (RqPBuf <> nil)
  then begin
     //   
     if (RqStat = rsDeletedRec) or (RqStat = rsDataRec)
     then begin
        //    MicroBase    
        if RqBase.SetRecDat(RqPBuf)
        then begin
           //  (  )   
           if RqBase.WriteRecToFile(RqStat, RqIndx)
           then Result := True;
        end;
     end;
  end;
end;

//------------------------------------------------------------------------
//     
//------------------------------------------------------------------------
//       
procedure TForm1.ButtAddRecClick(Sender: TObject);
var PDat : pointer;
begin
   if Assigned(MicroBase)
   then begin
      MakeNewFilterRecord(FRBuf);
      PDat := Addr(FRBuf);
      if MicroBase.SetRecDat(PDat)
      then begin
         MicroBase.AddRecToFile;
         LoadBaseSelector(MicroBase, rsDataRec, LBoxRecName);
         //   ListBox   
         if LBoxRecName.Count > 0
         then LBoxRecName.ItemIndex := LBoxRecName.Count -1;
      end;
   end;
end;
//------------------------------------------------------------------------
//      
procedure TForm1.LBoxRecNameClick(Sender: TObject);
var wIndx : integer;
begin
  wIndx := GetRecIndexFromBox(LBoxRecName);
  if (wIndx >= 0) and Assigned(MicroBase) and Assigned(ptFRBuf)
  then begin
     MicroBase.ReadRecFromFile(wIndx);
     //      
     if MicroBase.GetRecDat(ptFRBuf)
     then begin
        STextRecIndx.Caption := IntToStr(MicroBase.RecIndx);
        ShowBufRecord (FRBuf);
     end;
  end;
end;
//------------------------------------------------------------------------
//     ,   
procedure TForm1.ButtUpDateRecClick(Sender: TObject);
var wIndx : integer;
begin
  wIndx := GetRecIndexFromBox(LBoxRecName);
  if wIndx >= 0
  then begin
    SaveBufRecord (FRBuf);
    if WriteFilter(MicroBase, wIndx, ptFRBuf, rsDataRec)
    then begin
       wIndx := LBoxRecName.ItemIndex;
       LBoxRecName.Items.Strings[wIndx] := FRBuf.Name;
    end;
  end;
end;
//------------------------------------------------------------------------
//   ,    
procedure TForm1.ButtDelRecClick(Sender: TObject);
var wIndx : integer;
begin
  if CBoxRecStat.ItemIndex = 0
  then begin
     wIndx := GetRecIndexFromBox(LBoxRecName);
     if wIndx >= 0
     then begin
       SaveBufRecord (FRBuf);
       //       
       if WriteFilter(MicroBase, wIndx, ptFRBuf, rsDeletedRec)
       then LoadBaseSelector(MicroBase, rsDataRec, LBoxRecName);
     end;
  end;
end;
//------------------------------------------------------------------------
//   ,    
procedure TForm1.ButtRestoreRecClick(Sender: TObject);
var wIndx : integer;
begin
  if CBoxRecStat.ItemIndex = 1
  then begin
     wIndx := GetRecIndexFromBox(LBoxRecName);
     if wIndx >= 0
     then begin
       SaveBufRecord (FRBuf);
       //       
       if WriteFilter(MicroBase, wIndx, ptFRBuf, rsDataRec)
       then LoadBaseSelector(MicroBase, rsDeletedRec, LBoxRecName);
     end;
  end;
end;


//------------------------------------------------------------------------
//
//------------------------------------------------------------------------


end.
